/*
 * Decompiled with CFR 0.152.
 */
package autocalib;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;

public class FileManager {
    private static final String CONFIG_FILE_PATH = "autocalib.cfg";
    private static String com;
    private static String font;
    private static String lingua;
    private static String baudrate;
    private static final String TAG_COM = "-com";
    private static final String TAG_LANGUAGE = "-language";
    private static final String TAG_BAUDRATE = "-baudrate";

    public FileManager() {
        this.leggiConfigurationFile();
    }

    public String getConfigurationFont() {
        return font;
    }

    public String getConfigurationLingua() {
        return lingua.trim();
    }

    public String getConfigurationCom() {
        return com.trim();
    }

    public int getBaudRate() {
        try {
            int n = Integer.parseInt(baudrate.trim());
            return n;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Filemananger.getBaudRate::BaudRate conversion failed");
            return -1;
        }
    }

    public int getBaudRateHexa() {
        try {
            int result = Integer.parseInt(baudrate.trim());
            switch (result) {
                case 4800: {
                    int n = 0;
                    return n;
                }
                case 9600: {
                    int n = 1;
                    return n;
                }
                case 19200: {
                    int n = 2;
                    return n;
                }
                case 38400: {
                    int n = 3;
                    return n;
                }
                case 57600: {
                    int n = 4;
                    return n;
                }
                case 115200: {
                    int n = 5;
                    return n;
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Filemananger.getBaudRateHexa::BaudRate conversion failed");
        }
        return -1;
    }

    public void setBaudRate(int baud) {
        baudrate = String.valueOf(baud);
    }

    public void setBaudRate(String baud) {
        baudrate = baud;
    }

    public void aggiornaParametriConfiguration() {
    }

    private void leggiConfigurationFile() {
        try {
            String str;
            BufferedReader input = new BufferedReader(new FileReader(CONFIG_FILE_PATH));
            int idStart = -1;
            int idEnd = -1;
            while ((str = input.readLine()) != null) {
                idStart = str.lastIndexOf(TAG_COM);
                idEnd = str.indexOf(TAG_LANGUAGE);
                com = str.substring(idStart + TAG_COM.length(), idEnd);
                idStart = str.indexOf(TAG_LANGUAGE);
                idEnd = str.indexOf(TAG_BAUDRATE) == -1 ? str.length() : str.indexOf(TAG_BAUDRATE);
                lingua = str.substring(idStart + TAG_LANGUAGE.length(), idEnd);
                if (str.indexOf(TAG_BAUDRATE) == -1) continue;
                idStart = str.indexOf(TAG_BAUDRATE);
                idEnd = str.length();
                baudrate = str.substring(idStart + TAG_BAUDRATE.length(), idEnd);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Configuration File Not Found or File Error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        CONFIG_FILE_PATH = CONFIG_FILE_PATH;
        com = "0";
        lingua = "english";
        baudrate = "9600";
        TAG_COM = TAG_COM;
        TAG_LANGUAGE = TAG_LANGUAGE;
        TAG_BAUDRATE = TAG_BAUDRATE;
    }
}

